public class BisectSimple {
	public static double bisect(MathFunction func, double x1, double x2, double epsilon) {
		double m;
		int counter= 0;
		// Very rare case of double loop variables being ok
		for (m= (x1+x2)/2.0; Math.abs(x1-x2) > epsilon; m= (x1+x2)/2.0) {
			counter++;
			if  (func.f(x1)*func.f(m) <= 0.0)    // If func crosses zero in left sub
				x2= m;       // Use left subinterval
			else
				x1= m;       // Use right subinterval
		}
		System.out.println("Iterations: " + counter);
		return m;
	}

	public static void main(String[] args) {
		double root= BisectSimple.bisect(new Quadratic(), -8.0, 8.0, 1E-15);
		System.out.println("Root: " + root);
		System.out.println("Sqrt: " + -Math.sqrt(2.0));   // As a check     
	}
}